/*!
 *  Lang.js for Laravel localization in JavaScript.
 *
 *  @version 1.1.10
 *  @license MIT https://github.com/rmariuzzo/Lang.js/blob/master/LICENSE
 *  @site    https://github.com/rmariuzzo/Lang.js
 *  @author  Rubens Mariuzzo <rubens@mariuzzo.com>
 */
(function(root,factory){"use strict";if(typeof define==="function"&&define.amd){define([],factory)}else if(typeof exports==="object"){module.exports=factory()}else{root.Lang=factory()}})(this,function(){"use strict";function inferLocale(){if(typeof document!=="undefined"&&document.documentElement){return document.documentElement.lang}}function convertNumber(str){if(str==="-Inf"){return-Infinity}else if(str==="+Inf"||str==="Inf"||str==="*"){return Infinity}return parseInt(str,10)}var intervalRegexp=/^({\s*(\-?\d+(\.\d+)?[\s*,\s*\-?\d+(\.\d+)?]*)\s*})|([\[\]])\s*(-Inf|\*|\-?\d+(\.\d+)?)\s*,\s*(\+?Inf|\*|\-?\d+(\.\d+)?)\s*([\[\]])$/;var anyIntervalRegexp=/({\s*(\-?\d+(\.\d+)?[\s*,\s*\-?\d+(\.\d+)?]*)\s*})|([\[\]])\s*(-Inf|\*|\-?\d+(\.\d+)?)\s*,\s*(\+?Inf|\*|\-?\d+(\.\d+)?)\s*([\[\]])/;var defaults={locale:"en"};var Lang=function(options){options=options||{};this.locale=options.locale||inferLocale()||defaults.locale;this.fallback=options.fallback;this.messages=options.messages};Lang.prototype.setMessages=function(messages){this.messages=messages};Lang.prototype.getLocale=function(){return this.locale||this.fallback};Lang.prototype.setLocale=function(locale){this.locale=locale};Lang.prototype.getFallback=function(){return this.fallback};Lang.prototype.setFallback=function(fallback){this.fallback=fallback};Lang.prototype.has=function(key,locale){if(typeof key!=="string"||!this.messages){return false}return this._getMessage(key,locale)!==null};Lang.prototype.get=function(key,replacements,locale){if(!this.has(key,locale)){return key}var message=this._getMessage(key,locale);if(message===null){return key}if(replacements){message=this._applyReplacements(message,replacements)}return message};Lang.prototype.trans=function(key,replacements){return this.get(key,replacements)};Lang.prototype.choice=function(key,number,replacements,locale){replacements=typeof replacements!=="undefined"?replacements:{};replacements.count=number;var message=this.get(key,replacements,locale);if(message===null||message===undefined){return message}var messageParts=message.split("|");var explicitRules=[];for(var i=0;i<messageParts.length;i++){messageParts[i]=messageParts[i].trim();if(anyIntervalRegexp.test(messageParts[i])){var messageSpaceSplit=messageParts[i].split(/\s/);explicitRules.push(messageSpaceSplit.shift());messageParts[i]=messageSpaceSplit.join(" ")}}if(messageParts.length===1){return message}for(var j=0;j<explicitRules.length;j++){if(this._testInterval(number,explicitRules[j])){return messageParts[j]}}var pluralForm=this._getPluralForm(number);return messageParts[pluralForm]};Lang.prototype.transChoice=function(key,count,replacements){return this.choice(key,count,replacements)};Lang.prototype._parseKey=function(key,locale){if(typeof key!=="string"||typeof locale!=="string"){return null}var segments=key.split(".");var source=segments[0].replace(/\//g,".");return{source:locale+"."+source,sourceFallback:this.getFallback()+"."+source,entries:segments.slice(1)}};Lang.prototype._getMessage=function(key,locale){locale=locale||this.getLocale();key=this._parseKey(key,locale);if(this.messages[key.source]===undefined&&this.messages[key.sourceFallback]===undefined){return null}var message=this.messages[key.source];var entries=key.entries.slice();var subKey="";while(entries.length&&message!==undefined){var subKey=!subKey?entries.shift():subKey.concat(".",entries.shift());if(message[subKey]!==undefined){message=message[subKey];subKey=""}}if(typeof message!=="string"&&this.messages[key.sourceFallback]){message=this.messages[key.sourceFallback];entries=key.entries.slice();subKey="";while(entries.length&&message!==undefined){var subKey=!subKey?entries.shift():subKey.concat(".",entries.shift());if(message[subKey]){message=message[subKey];subKey=""}}}if(typeof message!=="string"){return null}return message};Lang.prototype._findMessageInTree=function(pathSegments,tree){while(pathSegments.length&&tree!==undefined){var dottedKey=pathSegments.join(".");if(tree[dottedKey]){tree=tree[dottedKey];break}tree=tree[pathSegments.shift()]}return tree};Lang.prototype._applyReplacements=function(message,replacements){for(var replace in replacements){message=message.replace(new RegExp(":"+replace,"gi"),function(match){var value=replacements[replace];var allCaps=match===match.toUpperCase();if(allCaps){return value.toUpperCase()}var firstCap=match===match.replace(/\w/i,function(letter){return letter.toUpperCase()});if(firstCap){return value.charAt(0).toUpperCase()+value.slice(1)}return value})}return message};Lang.prototype._testInterval=function(count,interval){if(typeof interval!=="string"){throw"Invalid interval: should be a string."}interval=interval.trim();var matches=interval.match(intervalRegexp);if(!matches){throw"Invalid interval: "+interval}if(matches[2]){var items=matches[2].split(",");for(var i=0;i<items.length;i++){if(parseInt(items[i],10)===count){return true}}}else{matches=matches.filter(function(match){return!!match});var leftDelimiter=matches[1];var leftNumber=convertNumber(matches[2]);if(leftNumber===Infinity){leftNumber=-Infinity}var rightNumber=convertNumber(matches[3]);var rightDelimiter=matches[4];return(leftDelimiter==="["?count>=leftNumber:count>leftNumber)&&(rightDelimiter==="]"?count<=rightNumber:count<rightNumber)}return false};Lang.prototype._getPluralForm=function(count){switch(this.locale){case"az":case"bo":case"dz":case"id":case"ja":case"jv":case"ka":case"km":case"kn":case"ko":case"ms":case"th":case"tr":case"vi":case"zh":return 0;case"af":case"bn":case"bg":case"ca":case"da":case"de":case"el":case"en":case"eo":case"es":case"et":case"eu":case"fa":case"fi":case"fo":case"fur":case"fy":case"gl":case"gu":case"ha":case"he":case"hu":case"is":case"it":case"ku":case"lb":case"ml":case"mn":case"mr":case"nah":case"nb":case"ne":case"nl":case"nn":case"no":case"om":case"or":case"pa":case"pap":case"ps":case"pt":case"so":case"sq":case"sv":case"sw":case"ta":case"te":case"tk":case"ur":case"zu":return count==1?0:1;case"am":case"bh":case"fil":case"fr":case"gun":case"hi":case"hy":case"ln":case"mg":case"nso":case"xbr":case"ti":case"wa":return count===0||count===1?0:1;case"be":case"bs":case"hr":case"ru":case"sr":case"uk":return count%10==1&&count%100!=11?0:count%10>=2&&count%10<=4&&(count%100<10||count%100>=20)?1:2;case"cs":case"sk":return count==1?0:count>=2&&count<=4?1:2;case"ga":return count==1?0:count==2?1:2;case"lt":return count%10==1&&count%100!=11?0:count%10>=2&&(count%100<10||count%100>=20)?1:2;case"sl":return count%100==1?0:count%100==2?1:count%100==3||count%100==4?2:3;case"mk":return count%10==1?0:1;case"mt":return count==1?0:count===0||count%100>1&&count%100<11?1:count%100>10&&count%100<20?2:3;case"lv":return count===0?0:count%10==1&&count%100!=11?1:2;case"pl":return count==1?0:count%10>=2&&count%10<=4&&(count%100<12||count%100>14)?1:2;case"cy":return count==1?0:count==2?1:count==8||count==11?2:3;case"ro":return count==1?0:count===0||count%100>0&&count%100<20?1:2;case"ar":return count===0?0:count==1?1:count==2?2:count%100>=3&&count%100<=10?3:count%100>=11&&count%100<=99?4:5;default:return 0}};return Lang});

(function () {
    Lang = new Lang();
    Lang.setMessages({"ar.js":{"Are_you_sure_to_send_invoice":"\u0647\u0644 \u0623\u0646\u062a \u0645\u062a\u0623\u0643\u062f \u0623\u0646\u0643 \u062a\u0631\u064a\u062f \u0625\u0631\u0633\u0627\u0644 \u0647\u0630\u0647 \u0627\u0644\u0641\u0627\u062a\u0648\u0631\u0629 \u0625\u0644\u0649 \u0627\u0644\u0639\u0645\u064a\u0644","account":"\u062d\u0633\u0627\u0628","all":"\u0627\u0644\u062c\u0645\u064a\u0639","all_notification_read":"\u062a\u0645\u062a \u0642\u0631\u0627\u0621\u0629 \u0643\u0627\u0641\u0629 \u0627\u0644\u0625\u062e\u0637\u0627\u0631\u0627\u062a \u0628\u0646\u062c\u0627\u062d","apply":"\u064a\u062a\u0642\u062f\u0645","apr":"\u0623\u0628\u0631\u064a\u0644","are_sure_want_to_delete_this_client_related_all_invoices":"\u0647\u0644 \u0623\u0646\u062a \u0645\u062a\u0623\u0643\u062f \u0623\u0646\u0643 \u062a\u0631\u064a\u062f \u062d\u0630\u0641 \u062c\u0645\u064a\u0639 \u0627\u0644\u0641\u0648\u0627\u062a\u064a\u0631 \u0627\u0644\u0645\u062a\u0639\u0644\u0642\u0629 \u0628\u0647\u0630\u0627 \u0627\u0644\u0639\u0645\u064a\u0644\u061f","are_you_sure_delete":"\u0647\u0644 \u062a\u0631\u064a\u062f \u0628\u0627\u0644\u062a\u0623\u0643\u064a\u062f \u062d\u0630\u0641 \u0647\u0630\u0627","are_you_sure_send":"\u0647\u0644 \u0623\u0646\u062a \u0645\u062a\u0623\u0643\u062f \u0623\u0646\u0643 \u062a\u0631\u064a\u062f \u0625\u0631\u0633\u0627\u0644 \u0647\u0630\u0647 \u0627\u0644\u0641\u0627\u062a\u0648\u0631\u0629 \u0625\u0644\u0649 \u0627\u0644\u0639\u0645\u064a\u0644\u061f","aug":"\u0623\u063a\u0633\u0637\u0633","cancel":"\u064a\u0644\u063a\u064a","category":"\u0641\u0626\u0629","client":"\u0639\u0645\u064a\u0644","copied_successfully":"\u062a\u0645 \u0627\u0644\u0646\u0633\u062e \u0628\u0646\u062c\u0627\u062d","currency":"\u0639\u0645\u0644\u0629","custom":"\u0645\u062e\u0635\u0635","dec":"\u062f\u064a\u0633\u0645\u0628\u0631","delete":"\u064a\u0645\u0633\u062d","deleted":"\u062a\u0645 \u0627\u0644\u062d\u0630\u0641!","enquiry":"\u0633\u0624\u0627\u0644","error":"\u062e\u0637\u0623","faqs":"\u0627\u0644\u0623\u0633\u0626\u0644\u0629 \u0627\u0644\u0634\u0627\u0626\u0639\u0629","feb":"\u0641\u0628\u0631\u0627\u064a\u0631","fri":"\u0627\u0644\u062c\u0645\u0639\u0629","from":"\u0645\u0646","has_been_deleted":"\u0642\u062f \u062a\u0645 \u062d\u0630\u0641.","invalid_country_code":"\u0631\u0645\u0632 \u0627\u0644\u0628\u0644\u062f \u063a\u064a\u0631 \u0635\u0627\u0644\u062d","invalid_number":"\u0631\u0642\u0645 \u063a\u064a\u0631 \u0635\u0627\u0644\u062d","invoice":"\u0641\u0627\u062a\u0648\u0631\u0629","jan":"\u064a\u0646\u0627\u064a\u0631","jul":"\u064a\u0648\u0644\u064a\u0648","jun":"\u064a\u0648\u0646\u064a\u0648","language_updated":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0644\u063a\u0629 \u0628\u0646\u062c\u0627\u062d.","last_30":"\u0622\u062e\u0631 30 \u064a\u0648\u0645\u064b\u0627","last_month":"\u0627\u0644\u0634\u0647\u0631 \u0627\u0644\u0645\u0627\u0636\u064a","last_week":"\u0627\u0644\u0623\u0633\u0628\u0648\u0639 \u0627\u0644\u0645\u0627\u0636\u064a","mar":"\u0645\u0627\u0631\u0633","may":"\u064a\u0645\u0643\u0646","mon":"\u0645\u0648\u0646","new_invoice":"\u0641\u0627\u062a\u0648\u0631\u0629 \u062c\u062f\u064a\u062f\u0629","no":"\u0644\u0627","no_cancel":"\u0644\u0627\u060c \u0625\u0644\u063a\u0627\u0621","no_record_found":"\u0644\u0627 \u064a\u0648\u062c\u062f \u0633\u062c\u0644\u0627\u062a","notification_read":"\u062a\u0645\u062a \u0642\u0631\u0627\u0621\u0629 \u0627\u0644\u0625\u0634\u0639\u0627\u0631 \u0628\u0646\u062c\u0627\u062d","nov":"\u0646\u0648\u0641\u0645\u0628\u0631","oct":"\u0623\u0643\u062a\u0648\u0628\u0631","ok":"\u0646\u0639\u0645","payment":"\u0642\u0633\u0637","payment_qr_code":"\u0631\u0645\u0632 \u0627\u0644\u0627\u0633\u062a\u062c\u0627\u0628\u0629 \u0627\u0644\u0633\u0631\u064a\u0639\u0629 \u0644\u0644\u062f\u0641\u0639","product":"\u0645\u0646\u062a\u062c","quote":"\u064a\u0642\u062a\u0628\u0633","sat":"\u0642\u0639\u062f","select_product":"\u062d\u062f\u062f \u0627\u0644\u0645\u0646\u062a\u062c \u0623\u0648 \u0623\u062f\u062e\u0644 \u0646\u0635\u064b\u0627 \u062d\u0631\u064b\u0627","select_tax":"\u062d\u062f\u062f \u0627\u0644\u0636\u0631\u064a\u0628\u0629","send":"\u064a\u0631\u0633\u0644","send_invoice":"\u0625\u0631\u0633\u0627\u0644 \u0627\u0644\u0641\u0627\u062a\u0648\u0631\u0629","sep":"\u0633\u0628\u062a\u0645\u0628\u0631","subscriber":"\u0627\u0644\u0645\u0634\u062a\u0631\u0643","subscription_plan":"\u062e\u0637\u0637 \u0627\u0644\u0627\u0634\u062a\u0631\u0627\u0643","successfully":"\u0628\u0646\u062c\u0627\u062d","sun":"\u0634\u0645\u0633","super_admin":"\u0627\u0644\u0645\u0634\u0631\u0641 \u0627\u0644\u0641\u0627\u0626\u0642","tax":"\u0636\u0631\u064a\u0628\u0629","testimonial":"\u0634\u0647\u0627\u062f\u0629","theme_changed":"\u062a\u0645 \u062a\u063a\u064a\u064a\u0631 \u0627\u0644\u0645\u0648\u0636\u0648\u0639 \u0628\u0646\u062c\u0627\u062d.","this_month":"\u0647\u0630\u0627 \u0627\u0644\u0634\u0647\u0631","this_week":"\u0647\u0630\u0627 \u0627\u0644\u0627\u0633\u0628\u0648\u0639","thu":"\u0627\u0644\u062e\u0645\u064a\u0633","to":"\u062a\u0645\u062a \u0645\u062d\u0627\u0633\u0628\u062a\u0647 \u0639\u0644\u0649","today":"\u0627\u0644\u064a\u0648\u0645","too_long":"\u0637\u0648\u064a\u0644 \u062c\u062f\u0627","too_short":"\u0642\u0635\u064a\u0631 \u062c\u062f\u0627","tue":"\u0627\u0644\u062b\u0644\u0627\u062b\u0627\u0621","user":"\u0645\u0633\u062a\u062e\u062f\u0645","valid_number":"\u0631\u0642\u0645 \u0635\u0627\u0644\u062d","wed":"\u062a\u0632\u0648\u062c","yes":"\u0646\u0639\u0645","yes_delete":"\u0646\u0639\u0645\u060c \u0627\u062d\u0630\u0641!","yes_send":"\u0646\u0639\u0645 \u0627\u0631\u0633\u0644","yesterday":"\u0623\u0645\u0633"},"de.js":{"Are_you_sure_to_send_invoice":"M\u00f6chten Sie diese Rechnung wirklich an den Kunden senden?","account":"Konto","all":"Alle","all_notification_read":"Alle Benachrichtigungen wurden erfolgreich gelesen","apply":"Anwenden","apr":"Apr","are_sure_want_to_delete_this_client_related_all_invoices":"Sind Sie sicher, dass Sie alle Rechnungen dieses Kunden l\u00f6schen m\u00f6chten?","are_you_sure_delete":"M\u00f6chten Sie dies wirklich l\u00f6schen?","are_you_sure_send":"M\u00f6chten Sie diese Rechnung wirklich an den Kunden senden?","aug":"Aug","cancel":"Stornieren","category":"Kategorie","client":"Klient","copied_successfully":"Erfolgreich kopiert","currency":"W\u00e4hrung","custom":"Brauch","dec":"Dez","delete":"L\u00f6schen","deleted":"Gel\u00f6scht!","enquiry":"Anfrage","error":"Fehler","faqs":"FAQs","feb":"Febr","fri":"FR","from":"Aus","has_been_deleted":"wurde gel\u00f6scht.","invalid_country_code":"Ung\u00fcltiger L\u00e4ndercode","invalid_number":"Ung\u00fcltige Nummer","invoice":"RECHNUNG","jan":"Jan","jul":"Juli","jun":"Jun","language_updated":"Sprache erfolgreich aktualisiert.","last_30":"Letzte 30 Tage","last_month":"Im vergangenen Monat","last_week":"Letzte Woche","mar":"Besch\u00e4digen","may":"Mai","mon":"MO","new_invoice":"Neue Rechnung","no":"NEIN","no_cancel":"Nein, Abbrechen","no_record_found":"Kein Eintrag gefunden","notification_read":"Benachrichtigung erfolgreich gelesen","nov":"Nov","oct":"Okt","ok":"OK","payment":"Zahlung","payment_qr_code":"Zahlungs-QR-Code","product":"Produkt","quote":"Zitat","sat":"SA","select_product":"Produkt ausw\u00e4hlen oder Freitext eingeben","select_tax":"W\u00e4hlen Sie Steuer aus","send":"Schicken","send_invoice":"Rechnung senden","sep":"Sept","subscriber":"Teilnehmer","subscription_plan":"Abonnementpl\u00e4ne","successfully":"Erfolgreich","sun":"SONNE","super_admin":"h\u00f6chster Vorgesetzter","tax":"Steuer","testimonial":"Zeugnis","theme_changed":"Thema erfolgreich ge\u00e4ndert.","this_month":"Diesen Monat","this_week":"Diese Woche","thu":"DO","to":"In Rechnung gestellt","today":"Heute","too_long":"Zu lang","too_short":"Zu kurz","tue":"DI","user":"Benutzer","valid_number":"G\u00fcltige Nummer","wed":"HEIRATEN","yes":"Ja","yes_delete":"Ja, l\u00f6schen!","yes_send":"Ja, senden","yesterday":"Gestern"},"en.js":{"Are_you_sure_to_send_invoice":"Are you sure want to send this invoice to client","account":"Account","all":"All","all_notification_read":"All Notification Read successfully","apply":"Apply","apr":"Apr","are_sure_want_to_delete_this_client_related_all_invoices":"Are you sure you want to delete this client related all invoices ?","are_you_sure_delete":"Are you sure want to delete this","are_you_sure_send":"Are you sure want to send this invoice to client ?","aug":"Aug","cancel":"Cancel","category":"Category","client":"Client","copied_successfully":"Copied Successfully","currency":"Currency","custom":"Custom","dec":"Dec","delete":"Delete","deleted":"Deleted!","enquiry":"Enquiry","error":"Error","faqs":"FAQs","feb":"Feb","fri":"FRI","from":"From","has_been_deleted":"has been deleted.","invalid_country_code":"Invalid country code","invalid_number":"Invalid Number","invoice":"INVOICE","jan":"Jan","jul":"Jul","jun":"Jun","language_updated":"Language updated successfully.","last_30":"Last 30 Days","last_month":"Last Month","last_week":"Last Week","mar":"Mar","may":"May","mon":"MON","new_invoice":"New Invoice","no":"No","no_cancel":"No, Cancel","no_record_found":"No Record Found","notification_read":"Notification Read successfully","nov":"Nov","oct":"Oct","ok":"Ok","payment":"Payment","payment_qr_code":"Payment QR Code","product":"Product","quote":"Quote","sat":"SAT","select_product":"Select Product or Enter free text","select_tax":"Select Tax","send":"Send","send_invoice":"Send Invoice","sep":"Sep","subscriber":"Subscriber","subscription_plan":"Subscription Plans","successfully":"Successfully","sun":"SUN","super_admin":"Super Admin","tax":"Tax","testimonial":"Testimonial","theme_changed":"Theme Changed Successfully.","this_month":"This Month","this_week":"This Week","thu":"THU","to":"Billed to","today":"Today","too_long":"Too long","too_short":"Too short","tue":"TUE","user":"User","valid_number":"Valid Number","wed":"WED","yes":"Yes","yes_delete":"Yes, Delete!","yes_send":"Yes, Send","yesterday":"Yesterday"},"es.js":{"Are_you_sure_to_send_invoice":"\u00bfEst\u00e1 seguro de que desea enviar esta factura al cliente?","account":"Cuenta","all":"Todo","all_notification_read":"Todas las notificaciones le\u00eddas correctamente","apply":"Aplicar","apr":"Abr","are_sure_want_to_delete_this_client_related_all_invoices":"\u00bfEst\u00e1 seguro de que desea eliminar todas las facturas relacionadas con este cliente?","are_you_sure_delete":"\u00bfEst\u00e1s seguro de que quieres eliminar esto?","are_you_sure_send":"\u00bfEst\u00e1 seguro de que desea enviar esta factura al cliente?","aug":"Ago","cancel":"Cancelar","category":"Categor\u00eda","client":"Cliente","copied_successfully":"Copiado correctamente","currency":"Divisa","custom":"Costumbre","dec":"Dic","delete":"Borrar","deleted":"\u00a1Eliminado!","enquiry":"Consulta","error":"Error","faqs":"Preguntas frecuentes","feb":"Feb","fri":"VIE","from":"De","has_been_deleted":"ha sido eliminado.","invalid_country_code":"C\u00f3digo de pa\u00eds no v\u00e1lido","invalid_number":"N\u00famero invalido","invoice":"FACTURA","jan":"Ene","jul":"Jul","jun":"Jun","language_updated":"Idioma actualizado exitosamente.","last_30":"\u00daltimos 30 d\u00edas","last_month":"El mes pasado","last_week":"La semana pasada","mar":"Mar","may":"Puede","mon":"LUN","new_invoice":"Nueva factura","no":"No","no_cancel":"No, cancelar","no_record_found":"ning\u00fan record fue encontrado","notification_read":"Notificaci\u00f3n le\u00edda con \u00e9xito","nov":"Nov","oct":"Oct","ok":"De acuerdo","payment":"Pago","payment_qr_code":"C\u00f3digo QR de pago","product":"Producto","quote":"Cita","sat":"SE SENT\u00d3","select_product":"Selecciona Producto o Introduce texto libre","select_tax":"Seleccionar Impuesto","send":"Enviar","send_invoice":"Enviar\u00e1 la factura","sep":"Sep","subscriber":"Abonado","subscription_plan":"Planes de suscripci\u00f3n","successfully":"Exitosamente","sun":"SOL","super_admin":"S\u00faper administrador","tax":"Impuesto","testimonial":"Testimonial","theme_changed":"El tema cambi\u00f3 con \u00e9xito.","this_month":"Este mes","this_week":"Esta semana","thu":"JUE","to":"Facturado a","today":"Hoy","too_long":"Demasiado largo","too_short":"Demasiado corto","tue":"MAR","user":"Usuario","valid_number":"N\u00famero v\u00e1lido","wed":"CASARSE","yes":"S\u00ed","yes_delete":"\u00a1S\u00ed, eliminar!","yes_send":"Si env\u00edalo","yesterday":"Ayer"},"fr.js":{"Are_you_sure_to_send_invoice":"\u00cates-vous s\u00fbr de vouloir envoyer cette facture au client","account":"Compte","all":"Tout","all_notification_read":"Toutes les notifications ont \u00e9t\u00e9 lues avec succ\u00e8s","apply":"Appliquer","apr":"Avr","are_sure_want_to_delete_this_client_related_all_invoices":"Etes-vous s\u00fbr de vouloir supprimer toutes les factures li\u00e9es \u00e0 ce client\u00a0?","are_you_sure_delete":"\u00cates-vous s\u00fbr de vouloir supprimer ceci","are_you_sure_send":"Etes-vous s\u00fbr de vouloir envoyer cette facture au client\u00a0?","aug":"Ao\u00fbt","cancel":"Annuler","category":"Cat\u00e9gorie","client":"Cliente","copied_successfully":"Copi\u00e9 avec succ\u00e8s","currency":"Devise","custom":"Coutume","dec":"D\u00e9c","delete":"Supprimer","deleted":"Supprim\u00e9\u00a0!","enquiry":"Enqu\u00eate","error":"Erreur","faqs":"FAQ","feb":"F\u00e9v","fri":"VEN","from":"Depuis","has_been_deleted":"a \u00e9t\u00e9 supprim\u00e9.","invalid_country_code":"Code de pays invalide","invalid_number":"Num\u00e9ro invalide","invoice":"FACTURE","jan":"Jan","jul":"Juillet","jun":"juin","language_updated":"Langue mise \u00e0 jour avec succ\u00e8s.","last_30":"Les 30 derniers jours","last_month":"Le mois dernier","last_week":"La semaine derni\u00e8re","mar":"Mar","may":"Peut","mon":"LUN","new_invoice":"Nouvelle facture","no":"Non","no_cancel":"Non, annuler","no_record_found":"Aucun Enregistrement Trouv\u00e9","notification_read":"Notification lu avec succ\u00e8s","nov":"Nov","oct":"Octobre","ok":"D'accord","payment":"Paiement","payment_qr_code":"Code QR de paiement","product":"Produit","quote":"Citation","sat":"ASSISE","select_product":"S\u00e9lectionnez un produit ou saisissez un texte libre","select_tax":"S\u00e9lectionnez la taxe","send":"Envoyer","send_invoice":"Envoyer une facture","sep":"Sep","subscriber":"Abonn\u00e9e","subscription_plan":"Plans d'abonnement","successfully":"Avec succ\u00e8s","sun":"SOLEIL","super_admin":"Super administrateur","tax":"Imp\u00f4t","testimonial":"T\u00e9moignage","theme_changed":"Le th\u00e8me a chang\u00e9 avec succ\u00e8s.","this_month":"Ce mois-ci","this_week":"Cette semaine","thu":"JEU","to":"Factur\u00e9 \u00e0","today":"Aujourd'hui","too_long":"Trop long","too_short":"Trop court","tue":"MAR","user":"Utilisatrice","valid_number":"Nombre valide","wed":"\u00c9POUSER","yes":"Oui","yes_delete":"Oui, supprimez\u00a0!","yes_send":"Oui envoyer","yesterday":"Hier"},"pt.js":{"Are_you_sure_to_send_invoice":"Tem certeza de que deseja enviar esta fatura ao cliente","account":"Conta","all":"Todos","all_notification_read":"Todas as notifica\u00e7\u00f5es lidas com sucesso","apply":"Aplicar","apr":"abril","are_sure_want_to_delete_this_client_related_all_invoices":"Tem certeza de que deseja excluir todas as faturas relacionadas a este cliente?","are_you_sure_delete":"Tem certeza de que deseja excluir isto","are_you_sure_send":"Tem certeza de que deseja enviar esta fatura ao cliente?","aug":"Agosto","cancel":"Cancelar","category":"Categoria","client":"Cliente","copied_successfully":"Copiado com sucesso","currency":"Moeda","custom":"Personalizado","dec":"dezembro","delete":"Excluir","deleted":"Exclu\u00eddo!","enquiry":"Investiga\u00e7\u00e3o","error":"Erro","faqs":"Perguntas frequentes","feb":"Fevereiro","fri":"SEX","from":"De","has_been_deleted":"foi deletado.","invalid_country_code":"C\u00f3digo de pa\u00eds inv\u00e1lido","invalid_number":"N\u00famero inv\u00e1lido","invoice":"FATURA","jan":"janeiro","jul":"julho","jun":"junho","language_updated":"Idioma atualizado com sucesso.","last_30":"\u00daltimos 30 dias","last_month":"M\u00eas passado","last_week":"Semana passada","mar":"mar\u00e7o","may":"Poderia","mon":"SEG","new_invoice":"Nova fatura","no":"N\u00e3o","no_cancel":"N\u00e3o, cancelar","no_record_found":"Nenhum Registro Encontrado","notification_read":"Notifica\u00e7\u00e3o lida com sucesso","nov":"Novembro","oct":"Outubro","ok":"OK","payment":"Pagamento","payment_qr_code":"C\u00f3digo QR de pagamento","product":"produtos","quote":"Citar","sat":"SENTADO","select_product":"Selecione Produto ou Insira texto livre","select_tax":"Selecione Imposto","send":"Enviar","send_invoice":"Enviar fatura","sep":"Setembro","subscriber":"Assinante","subscription_plan":"Planos de assinatura","successfully":"Com sucesso","sun":"SOL","super_admin":"Superadministrador","tax":"Imposto","testimonial":"Depoimento","theme_changed":"Tema alterado com sucesso.","this_month":"Este m\u00eas","this_week":"Essa semana","thu":"QUI","to":"Faturado para","today":"Hoje","too_long":"Demasiado longo","too_short":"Muito curto","tue":"TER","user":"Do utilizador","valid_number":"N\u00famero v\u00e1lido","wed":"QUA","yes":"Sim","yes_delete":"Sim, excluir!","yes_send":"Sim envie","yesterday":"Ontem"},"ru.js":{"Are_you_sure_to_send_invoice":"\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u044d\u0442\u043e\u0442 \u0441\u0447\u0435\u0442 \u043a\u043b\u0438\u0435\u043d\u0442\u0443?","account":"\u0421\u0447\u0435\u0442","all":"\u0412\u0441\u0435","all_notification_read":"\u0412\u0441\u0435 \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u044f \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u043d\u044b","apply":"\u041f\u0440\u0438\u043c\u0435\u043d\u044f\u0442\u044c","apr":"\u0430\u043f\u0440\u0435\u043b\u044c","are_sure_want_to_delete_this_client_related_all_invoices":"\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u0441\u0435 \u0441\u0447\u0435\u0442\u0430, \u0441\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0435 \u0441 \u044d\u0442\u0438\u043c \u043a\u043b\u0438\u0435\u043d\u0442\u043e\u043c?","are_you_sure_delete":"\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u044d\u0442\u043e?","are_you_sure_send":"\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u044d\u0442\u043e\u0442 \u0441\u0447\u0435\u0442 \u043a\u043b\u0438\u0435\u043d\u0442\u0443?","aug":"\u0430\u0432\u0433\u0443\u0441\u0442","cancel":"\u041e\u0442\u043c\u0435\u043d\u0430","category":"\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f","client":"\u041a\u043b\u0438\u0435\u043d\u0442","copied_successfully":"\u0421\u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u043d\u043e \u0443\u0441\u043f\u0435\u0448\u043d\u043e","currency":"\u0412\u0430\u043b\u044e\u0442\u0430","custom":"\u041e\u0431\u044b\u0447\u0430\u0439","dec":"\u0434\u0435\u043a\u0430\u0431\u0440\u044c","delete":"\u0423\u0434\u0430\u043b\u0438\u0442\u044c","deleted":"\u0423\u0434\u0430\u043b\u0435\u043d\u043e!","enquiry":"\u0420\u0430\u0441\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u0435","error":"\u041e\u0448\u0438\u0431\u043a\u0430","faqs":"\u0427\u0430\u0441\u0442\u043e \u0437\u0430\u0434\u0430\u0432\u0430\u0435\u043c\u044b\u0435 \u0432\u043e\u043f\u0440\u043e\u0441\u044b","feb":"\u0444\u0435\u0432\u0440\u0430\u043b\u044c","fri":"\u041f\u0422","from":"\u041e\u0442","has_been_deleted":"\u0431\u044b\u043b \u0443\u0434\u0430\u043b\u0435\u043d.","invalid_country_code":"\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043a\u043e\u0434 \u0441\u0442\u0440\u0430\u043d\u044b","invalid_number":"\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440","invoice":"\u0421\u0427\u0415\u0422","jan":"\u042f\u043d","jul":"\u0438\u044e\u043b\u044c","jun":"\u0438\u044e\u043d\u044c","language_updated":"\u042f\u0437\u044b\u043a \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d.","last_30":"\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 30 \u0434\u043d\u0435\u0439","last_month":"\u041f\u0440\u043e\u0448\u043b\u044b\u0439 \u043c\u0435\u0441\u044f\u0446","last_week":"\u041d\u0430 \u043f\u0440\u043e\u0448\u043b\u043e\u0439 \u043d\u0435\u0434\u0435\u043b\u0435","mar":"\u041c\u0430\u0440","may":"\u041c\u043e\u0436\u0435\u0442","mon":"\u041f\u041d","new_invoice":"\u041d\u043e\u0432\u044b\u0439 \u0441\u0447\u0435\u0442","no":"\u041d\u0435\u0442","no_cancel":"\u041d\u0435\u0442, \u043e\u0442\u043c\u0435\u043d\u0438\u0442\u044c","no_record_found":"\u0417\u0430\u043f\u0438\u0441\u044c \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430","notification_read":"\u0423\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0435 \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u043d\u043e \u0443\u0441\u043f\u0435\u0448\u043d\u043e","nov":"\u043d\u043e\u044f\u0431\u0440\u044c","oct":"\u043e\u043a\u0442\u044f\u0431\u0440\u044c","ok":"\u0425\u043e\u0440\u043e\u0448\u043e","payment":"\u041e\u043f\u043b\u0430\u0442\u0430","payment_qr_code":"QR-\u043a\u043e\u0434 \u043e\u043f\u043b\u0430\u0442\u044b","product":"\u041f\u0440\u043e\u0434\u0443\u043a\u0442","quote":"\u0426\u0438\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c","sat":"\u0421\u0418\u0414\u0415\u041b","select_product":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0440\u043e\u0434\u0443\u043a\u0442 \u0438\u043b\u0438 \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u043b\u044c\u043d\u044b\u0439 \u0442\u0435\u043a\u0441\u0442","select_tax":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043d\u0430\u043b\u043e\u0433","send":"\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0442\u044c","send_invoice":"\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0441\u0447\u0435\u0442-\u0444\u0430\u043a\u0442\u0443\u0440\u0443","sep":"\u0421\u0435\u043d\u0442\u044f\u0431\u0440\u044c","subscriber":"\u043f\u043e\u0434\u043f\u0438\u0441\u0447\u0438\u043a","subscription_plan":"\u041f\u043b\u0430\u043d\u044b \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438","successfully":"\u0423\u0441\u043f\u0435\u0448\u043d\u043e","sun":"\u0421\u041e\u041b\u041d\u0426\u0415","super_admin":"\u0421\u0443\u043f\u0435\u0440\u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440","tax":"\u041d\u0430\u043b\u043e\u0433","testimonial":"\u041e\u0442\u0437\u044b\u0432","theme_changed":"\u0422\u0435\u043c\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0430.","this_month":"\u042d\u0442\u043e\u0442 \u043c\u0435\u0441\u044f\u0446","this_week":"\u041d\u0430 \u044d\u0442\u043e\u0439 \u043d\u0435\u0434\u0435\u043b\u0435","thu":"\u0427\u0422","to":"\u0421\u0447\u0435\u0442 \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u0435\u043d \u043d\u0430","today":"\u0421\u0435\u0433\u043e\u0434\u043d\u044f","too_long":"\u0421\u043b\u0438\u0448\u043a\u043e\u043c \u0434\u043e\u043b\u0433\u043e","too_short":"\u0421\u043b\u0438\u0448\u043a\u043e\u043c \u043a\u043e\u0440\u043e\u0442\u043a\u0438\u0439","tue":"\u0412\u0422","user":"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c","valid_number":"\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440","wed":"\u041e\u0411\u0412\u0415\u041d\u0427\u0410\u041b\u0418\u0421\u042c","yes":"\u0414\u0430","yes_delete":"\u0414\u0430, \u0443\u0434\u0430\u043b\u0438\u0442\u044c!","yes_send":"\u0414\u0430, \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c","yesterday":"\u0412\u0447\u0435\u0440\u0430"},"tr.js":{"Are_you_sure_to_send_invoice":"Bu faturay\u0131 m\u00fc\u015fteriye g\u00f6ndermek istedi\u011finizden emin misiniz?","account":"Hesap","all":"T\u00fcm","all_notification_read":"T\u00fcm Bildirimler ba\u015far\u0131yla okundu","apply":"Uygula","apr":"Nisan","are_sure_want_to_delete_this_client_related_all_invoices":"Bu m\u00fc\u015fteriyle ilgili t\u00fcm faturalar\u0131 silmek istedi\u011finizden emin misiniz?","are_you_sure_delete":"Bunu silmek istedi\u011finden emin misin?","are_you_sure_send":"Bu faturay\u0131 m\u00fc\u015fteriye g\u00f6ndermek istedi\u011finizden emin misiniz?","aug":"A\u011fustos","cancel":"\u0130ptal etmek","category":"Kategori","client":"M\u00fc\u015fteri","copied_successfully":"Ba\u015far\u0131yla Kopyaland\u0131","currency":"Para birimi","custom":"Gelenek","dec":"Aral\u0131k","delete":"Silmek","deleted":"Silindi!","enquiry":"Sorgu","error":"Hata","faqs":"SSS","feb":"\u015eubat","fri":"Cuma","from":"\u0130tibaren","has_been_deleted":"silindi.","invalid_country_code":"Ge\u00e7ersiz \u00fclke kodu","invalid_number":"Ge\u00e7ersiz numara","invoice":"FATURA","jan":"Ocak","jul":"Temmuz","jun":"Haziran","language_updated":"Dil ba\u015far\u0131yla g\u00fcncellendi.","last_30":"Son 30 g\u00fcn","last_month":"Ge\u00e7en ay","last_week":"Ge\u00e7en hafta","mar":"Mart","may":"May\u0131s","mon":"PZT","new_invoice":"Yeni fatura","no":"HAYIR","no_cancel":"Hay\u0131r, \u0130ptal","no_record_found":"Kay\u0131t Bulunamad\u0131","notification_read":"Bildirim ba\u015far\u0131yla okundu","nov":"Kas\u0131m","oct":"Ekim","ok":"Tamam","payment":"\u00d6deme","payment_qr_code":"\u00d6deme QR Kodu","product":"\u00dcr\u00fcn","quote":"Al\u0131nt\u0131","sat":"DOYGUNLUK","select_product":"\u00dcr\u00fcn Se\u00e7in veya Serbest Metin Girin","select_tax":"Vergi Se\u00e7iniz","send":"G\u00f6ndermek","send_invoice":"Fatura G\u00f6nder","sep":"Eyl\u00fcl","subscriber":"Abone","subscription_plan":"Abonelik Planlar\u0131","successfully":"Ba\u015far\u0131yla","sun":"G\u00dcNE\u015e","super_admin":"S\u00fcper Y\u00f6netici","tax":"Vergi","testimonial":"Referans","theme_changed":"Tema Ba\u015far\u0131yla De\u011fi\u015ftirildi.","this_month":"Bu ay","this_week":"Bu hafta","thu":"per\u015f","to":"Fatura","today":"Bug\u00fcn","too_long":"\u00c7ok uzun","too_short":"\u00c7ok k\u0131sa","tue":"SALI","user":"Kullan\u0131c\u0131","valid_number":"Ge\u00e7erli numara","wed":"EVLENMEK","yes":"Evet","yes_delete":"Evet, Sil!","yes_send":"Evet G\u00f6nder","yesterday":"D\u00fcn"},"zh.js":{"Are_you_sure_to_send_invoice":"\u60a8\u78ba\u5b9a\u8981\u5c07\u6b64\u767c\u7968\u5bc4\u7d66\u5ba2\u6236\u55ce","account":"\u5e33\u6236","all":"\u5168\u90e8","all_notification_read":"\u6240\u6709\u901a\u77e5\u8b80\u53d6\u6210\u529f","apply":"\u7533\u8acb","apr":"\u56db\u6708","are_sure_want_to_delete_this_client_related_all_invoices":"\u60a8\u78ba\u5b9a\u8981\u522a\u9664\u8207\u8a72\u5ba2\u6236\u76f8\u95dc\u7684\u6240\u6709\u767c\u7968\u55ce\uff1f","are_you_sure_delete":"\u60a8\u78ba\u5b9a\u8981\u522a\u9664\u6b64\u5167\u5bb9\u55ce","are_you_sure_send":"\u60a8\u78ba\u5b9a\u8981\u5c07\u6b64\u767c\u7968\u5bc4\u7d66\u5ba2\u6236\u55ce\uff1f","aug":"\u516b\u6708","cancel":"\u53d6\u6d88","category":"\u985e\u5225","client":"\u5ba2\u6236","copied_successfully":"\u8907\u88fd\u6210\u529f","currency":"\u8ca8\u5e63","custom":"\u98a8\u4fd7","dec":"\u5341\u4e8c\u6708","delete":"\u522a\u9664","deleted":"\u5df2\u522a\u9664\uff01","enquiry":"\u8a62\u554f","error":"\u932f\u8aa4","faqs":"\u5e38\u898b\u554f\u984c\u89e3\u7b54","feb":"\u4e8c\u6708","fri":"\u5f17\u745e","from":"\u5f9e","has_been_deleted":"\u5df2\u522a\u9664\u3002","invalid_country_code":"\u570b\u5bb6\u4ee3\u78bc\u7121\u6548","invalid_number":"\u7121\u6548\u865f\u78bc","invoice":"\u767c\u7968","jan":"\u63da","jul":"\u4e03\u6708","jun":"\u541b","language_updated":"\u8a9e\u8a00\u66f4\u65b0\u6210\u529f\u3002","last_30":"\u904e\u53bb 30 \u5929","last_month":"\u4e0a\u500b\u6708","last_week":"\u4e0a\u500b\u661f\u671f","mar":"\u4e09\u6708","may":"\u53ef\u80fd","mon":"\u9031\u4e00","new_invoice":"\u65b0\u767c\u7968","no":"\u4e0d","no_cancel":"\u4e0d\uff0c\u53d6\u6d88","no_record_found":"\u6c92\u6709\u627e\u5230\u8a18\u9304","notification_read":"\u901a\u77e5\u8b80\u53d6\u6210\u529f","nov":"\u5341\u4e00\u6708","oct":"\u5341\u6708","ok":"\u597d\u7684","payment":"\u652f\u4ed8","payment_qr_code":"\u652f\u4ed8\u4e8c\u7dad\u78bc","product":"\u7522\u54c1","quote":"\u5f15\u7528","sat":"SAT","select_product":"\u9078\u64c7\u7522\u54c1\u6216\u8f38\u5165\u81ea\u7531\u6587\u5b57","select_tax":"\u9078\u64c7\u7a05\u8cbb","send":"\u50b3\u9001","send_invoice":"\u5bc4\u51fa\u767c\u7968","sep":"\u4e5d\u6708","subscriber":"\u8a02\u6236","subscription_plan":"\u8a02\u95b1\u8a08\u5283","successfully":"\u6210\u529f\u5730","sun":"\u592a\u967d","super_admin":"\u8d85\u7ba1\u7406\u54e1","tax":"\u7a05","testimonial":"\u611f\u8a00","theme_changed":"\u4e3b\u984c\u66f4\u6539\u6210\u529f\u3002","this_month":"\u9019\u500b\u6708","this_week":"\u672c\u661f\u671f","thu":"\u9031\u56db","to":"\u4ed8\u6b3e\u4eba","today":"\u4eca\u5929","too_long":"\u592a\u9577","too_short":"\u904e\u77ed","tue":"\u6cbb\u7642\u8cbb\u7528","user":"\u4f7f\u7528\u8005","valid_number":"\u6709\u6548\u865f\u78bc","wed":"\u661f\u671f\u4e09","yes":"\u662f\u7684","yes_delete":"\u662f\u7684\uff0c\u522a\u9664\uff01","yes_send":"\u662f\u7684\uff0c\u767c\u9001","yesterday":"\u6628\u5929"}});
})();
